import Link from 'next/link'

const services = [
  {
    title: 'Basic Wash & Wax',
    price: 'Starting at $49',
    features: ['Exterior wash', 'Tire cleaning', 'Wax application', 'Interior vacuum'],
    popular: false,
  },
  {
    title: 'Premium Detail',
    price: 'Starting at $149',
    features: ['Full exterior detail', 'Clay bar treatment', 'Interior deep clean', 'Leather conditioning', 'Engine bay cleaning'],
    popular: true,
  },
  {
    title: 'Paint Correction',
    price: 'Starting at $299',
    features: ['Multi-stage polish', 'Swirl removal', 'Ceramic coating option', 'Paint protection'],
    popular: false,
  },
  {
    title: 'Interior Restoration',
    price: 'Starting at $99',
    features: ['Deep carpet cleaning', 'Stain removal', 'Odor elimination', 'Dashboard restoration'],
    popular: false,
  },
]

export default function Services() {
  return (
    <section className="py-20 bg-gray-50">
      <div className="container">
        <div className="text-center mb-12">
          <h2 className="text-4xl md:text-5xl font-bold text-gray-900 mb-4">
            Our Services
          </h2>
          <p className="text-xl text-gray-600 max-w-2xl mx-auto">
            Professional auto detailing services to keep your vehicle looking its best
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {services.map((service, index) => (
            <div 
              key={index} 
              className={`card relative ${service.popular ? 'ring-2 ring-red-600' : ''}`}
            >
              {service.popular && (
                <div className="absolute -top-3 left-1/2 transform -translate-x-1/2">
                  <span className="bg-red-600 text-white px-3 py-1 rounded-full text-xs font-semibold">
                    MOST POPULAR
                  </span>
                </div>
              )}
              
              <h3 className="text-xl font-bold text-gray-900 mb-2">
                {service.title}
              </h3>
              <p className="text-2xl font-bold text-red-600 mb-4">
                {service.price}
              </p>
              
              <ul className="space-y-2 mb-6">
                {service.features.map((feature, idx) => (
                  <li key={idx} className="flex items-start">
                    <span className="text-green-500 mr-2">✓</span>
                    <span className="text-gray-600 text-sm">{feature}</span>
                  </li>
                ))}
              </ul>
              
              <Link 
                href="/contact" 
                className={`block text-center py-2 px-4 rounded ${
                  service.popular 
                    ? 'bg-red-600 text-white hover:bg-red-700' 
                    : 'bg-gray-200 text-gray-800 hover:bg-gray-300'
                } transition-colors`}
              >
                Book Now
              </Link>
            </div>
          ))}
        </div>

        <div className="text-center mt-12">
          <Link href="/services" className="btn-primary">
            View All Services
          </Link>
        </div>
      </div>
    </section>
  )
}
